require( "quest/m3_apartment_closeup/convout.lua" );
combine_speech_tables();

book_title_text_spec = 
{
	color = { a = 0.75, r = 1, g = 1, b = 1 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 30,
	h = 80,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar1_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 60,
	h = 60,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar2_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 40,
	h = 80,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar3_text_spec = 
{
	color = { a = 1, r = 1, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 50,
	h = 80,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar4_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 50,
	h = 80,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar5_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 1 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 50,
	h = 80,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.LEFT;
};

calendar6_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 30,
	linepadding = 5,
	h = 20,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.RIGHT;
};

phone_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 20,
	linepadding = 0,
	h = 20,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.RIGHT;
};

remote_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 20,
	linepadding = 1,
	h = 200,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.RIGHT;
};

shoe_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	--w = 800,
	--h = 600,
	bubble = false,
	lineheight = 20,
	linepadding = 1,
	h = 20,
	outline_size = 0,
	--fixed = true,
	font = "fonts/franklingothic_demicond.mvec"; 
	--anchor = ANCHOR.TOP;
	--halign = HALIGN.RIGHT;
};

TEXT_DATA = 
{
	POSITION = 1,
	TEXT = 2,
	TEXT_SPEC = 3,
};

closeup_info = 
{
	-- 1
	{
		image = "closeup_bookshelf",
		halo = "closeup_bookshelf",
		text = 
		{
			--{ { { x = 628, y = 460 }, { x = 770, y = 460 }, { x = 628, y = 475 }, { x = 770, y = 475 } }, "text_book1", book_title_text_spec },
			--{ { { x = 628, y = 460 }, { x = 770, y = 460 }, { x = 628, y = 475 }, { x = 770, y = 475 } }, "text_book2", book_title_text_spec },
			{ { { x = 370, y = 242 }, { x = 416, y = 242 }, { x = 370, y = 270 }, { x = 416, y = 270 } }, "text_book3", book_title_text_spec },
		},
	},
	
	-- 2
	{
		image = "closeup_calendar",
		halo = "closeup",
		text = 
		{
			{ { { x = 367, y = 104 }, { x = 405, y = 99 }, { x = 381, y = 180 }, { x = 417, y = 173 } }, "text_calendar1", calendar1_text_spec },
			{ { { x = 428, y = 104 }, { x = 488, y = 92 }, { x = 435, y = 131 }, { x = 495, y = 118 } }, "text_calendar2", calendar2_text_spec },
			{ { { x = 302, y = 185 }, { x = 332, y = 181 }, { x = 304, y = 204 }, { x = 332, y = 196 } }, "text_calendar3", calendar3_text_spec },
			{ { { x = 331, y = 180 }, { x = 476, y = 146 }, { x = 334, y = 196 }, { x = 479, y = 162 } }, "text_calendar4", calendar4_text_spec },
			{ { { x = 477, y = 145 }, { x = 499, y = 141 }, { x = 480, y = 163 }, { x = 503, y = 158 } }, "text_calendar5", calendar5_text_spec },
			{ { { x = 305, y = 205 }, { x = 503, y = 158 }, { x = 309, y = 238 }, { x = 508, y = 191 } }, "text_calendar6", calendar6_text_spec },
			{ { { x = 309, y = 238 }, { x = 508, y = 191 }, { x = 312, y = 274 }, { x = 511, y = 228 } }, "text_calendar7", calendar6_text_spec },
			{ { { x = 312, y = 274 }, { x = 511, y = 228 }, { x = 314, y = 308 }, { x = 513, y = 261 } }, "text_calendar8", calendar6_text_spec },
			{ { { x = 314, y = 308 }, { x = 513, y = 261 }, { x = 315, y = 345 }, { x = 514, y = 299 } }, "text_calendar9", calendar6_text_spec },
			{ { { x = 315, y = 345 }, { x = 514, y = 299 }, { x = 315, y = 375 }, { x = 514, y = 329 } }, "text_calendar10", calendar6_text_spec },
		},
	}, 
	
	--3 
	{
		image = "closeup_painting",
		halo = "closeup",
		text = {};
	},
	
	-- 4
	{
		image = "closeup_phone",
		halo = "closeup",
		text = 
		{
			{ { { x = 409, y = 232 }, { x = 526, y = 232 }, { x = 409, y = 252 }, { x = 526, y = 252 } }, "text_phone1", phone_text_spec },
			{ { { x = 409, y = 272 }, { x = 526, y = 272 }, { x = 409, y = 292 }, { x = 526, y = 292 } }, "text_phone2", phone_text_spec },
			{ { { x = 409, y = 310 }, { x = 526, y = 310 }, { x = 409, y = 330 }, { x = 526, y = 330 } }, "text_phone3", phone_text_spec },
			{ { { x = 409, y = 349 }, { x = 526, y = 349 }, { x = 409, y = 369 }, { x = 526, y = 369 } }, "text_phone4", phone_text_spec },
		},
	},
	
	-- 5
	{
		image = "closeup_remote",
		halo = "closeup",
		text = 
		{
			{ { { x = 450, y = 329 }, { x = 513, y = 304 }, { x = 493, y = 379 }, { x = 556, y = 352 } }, "text_remote1", remote_text_spec },
		},
	},
	
	-- 6
	{
		image = "closeup_shoes";
		halo = "closeup",
		text = 
		{
			{ { { x = 343, y = 128 }, { x = 369, y = 119 }, { x = 342, y = 145 }, { x = 369, y = 138 } }, "text_shoesize1", shoe_text_spec },
			{ { { x = 510, y = 131 }, { x = 532, y = 120 }, { x = 505, y = 151 }, { x = 526, y = 141 } }, "text_shoesize2", shoe_text_spec },
			{ { { x = 521, y = 164 }, { x = 539, y = 146 }, { x = 523, y = 186 }, { x = 540, y = 168 } }, "text_shoesize2", shoe_text_spec },
		},
	},
};

flo_spec =
{
	name = "FLO";

	command = function(actor)
		prepare_actor_text(actor, flo_text_spec)
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function spawn_closeup(closeup_num)
	return scene:Spawn
	{
		name = "CLOSEUP_IMAGE_" .. closeup_num;
		image = closeup_info[closeup_num].image;
		halo = closeup_info[closeup_num].halo;
		
		command = function(actor)
			actor:SetPointAtCursor("cursor");
			actor:SetDepthValue(1);
			
			spawn_texts(closeup_num);
		end;
	};
end

function spawn_texts(closeup_num)
	for i,v in closeup_info[closeup_num].text do 
		spawn_text(closeup_num, i);
	end;
end

function spawn_text(closeup_num, text_num)
	return scene:Spawn
	{
		name = "TEXT_" .. closeup_num .. "_" .. text_num;
		
		command = function(actor)
			local text_data = closeup_info[closeup_num].text[text_num];
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:SetDepthValue(15);
			actor:ModifySaySpec(text_data[TEXT_DATA.TEXT_SPEC]);
			actor:Say(text_data[TEXT_DATA.TEXT]);
			actor:SetPolygon(text_data[TEXT_DATA.POSITION][1], text_data[TEXT_DATA.POSITION][2], text_data[TEXT_DATA.POSITION][3], text_data[TEXT_DATA.POSITION][4]);
			actor:TextToImage(1, 1);
		end;
	};
end

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	--point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		scene:ReturnFromScene();
		game:ClearInvUsage();
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		if IsCheatMode() then
			--testing
			if game:Get("m3_apartment_closeup_num") < 1 then
				game:Set("m3_apartment_closeup_num", 1);
			end
		end
		
		fade_scene_up(false,true);
		
		spawn_closeup(game:Get("m3_apartment_closeup_num"));
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", 1 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec,
		back_spec,
		scene_setup,
	};
};
